/* 
 * File:   lcd.h
 * Author: Gabor
 *
 * Created on 2015. jnius 18., 11:59
 */

#ifndef LCD_H
#define	LCD_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "system.h"
#include <stdint.h>
    
#define LcdCmd(x)WriteSPI(0xFE);WriteSPI(x);
#define LcdData(x)WriteSPI(x);
#define LcdBacklight(x)WriteSPI(0xEE);WriteSPI(x);
#define LcdContrast(x)WriteSPI(0xED);WriteSPI(~x);

#define baud(x) SPBRGL = (int)((((float)_XTAL_FREQ / (float)x) / 4.0) - 1.0) & 0xFF ;\
                SPBRGH = (int)((((float)_XTAL_FREQ / (float)x) / 4.0) - 1.0) >> 8 & 0xFF
#define SPIBAUD(x) SSP1ADD =  ((unsigned char)(_XTAL_FREQ / ((double)x*(double)4)))-1            
    
void WriteSPI(unsigned char );
void LcdInit(void );
void LcdPutc(char );
void LcdPuts(const char *);
void LcdPuts_16(const char *);
void LcdMain(void);

#ifdef	__cplusplus
}
#endif

#endif	/* LCD_H */

